<?php
namespace model;

class Trash extends \Pawn\Model
{
	// Administration
	const sortColumn = 'ts_create';
	const sortAscending = 0;
	
	public function listing()
	{
		return array
		(
			'model_id'	=>	call_user_func(array('\\model\\'.$this->model, 'get'), 'WHERE id=?', $this->model_id, 1)->fetch()->__toString(),
			'model'		=>	\lib\Lang::get('admin', $this->model, 'instance'),
			'ts_create'	=>	\lib\Lang::get('edited_by', array
			(
				'date'	=>	\Pawn::get_date($this->ts_edit),
				'user'	=>	User::get('WHERE id=?', $this->user_id)->fetch()->__toString()
			))
		);
	}
	
	public static function bulk()
	{
		return array
		(
			'delete'	=>	true,
			'restore'	=>	true,
			'edit'		=>	false
		);
	}
	
	// Validation
	public function columns()
	{
		return array
		(
			'model'		=>	array('FieldObject', array())
		);
	}
	
	public function fields($action, $fields)
	{
		return array
		(
			'model'		=>	substr(get_class($fields['model']), 6),
			'model_id'	=>	$fields['model']->id,
			'user_id'	=>	\lib\Session::user()->id
		);
	}
	
	// Migration
	public static function migration()
	{
		return array
		(
			array('CREATE', array
			(
				'model'		=>	'VARCHAR(32)',
				'model_id'	=>	'INT UNSIGNED',
				'user_id'	=>	'INT UNSIGNED'
			))
		);
	}
	
	// Delete
	public function delete($files=array())
	{
		call_user_func(array('\\model\\'.$this->model, 'get'), 'WHERE id=?', $this->model_id, 1)->fetch()->delete();
		
		if($action = \model\Home::get('WHERE model_id=? AND model=?', array($this->model_id, $this->model))->fetch())
		{
			$action->delete();
		}
		
		parent::delete();
	}
	
	// Restore
	public function restore()
	{
		$instance = call_user_func(array('\\model\\'.$this->model, 'get'), 'WHERE id=?', $this->model_id, 1)->fetch();
		
		$instance->restore();
		
		if($action = \model\Home::get('WHERE model_id=? AND model=? AND action="trash"', array($this->model_id, $this->model))->fetch())
		{
			$action->delete();
		}
		
		parent::delete();
	}
}